<?php

/**
 * renders certificate
 * checks if user is it's owner
 */
class BookNoteAction extends CAction
{
	public function run($id)
	{
		$id = filter_var($id, FILTER_VALIDATE_INT);

		$zlecenie = ZlecenieFirmy::model()
			->with('idFirmy0.biura.budynek', 'idZlecenia0.dziedzina', 'kontrahent', 'idFirmy0.klasa.szkola.idMapy0')
			->find('"t"."id" = :id AND "t"."czasPodjecia" IS NOT NULL AND
				"t"."czasZakonczenia" IS NOT NULL AND "t"."idOdpowiedzi" IS NULL',
				array(':id' => $id));

		if (empty($zlecenie))
			throw new CHttpException(404, 'Nie ma podanej noty.');

		//w przypadku przetargów nie ma idFirmy, ale jest idGrupyPrzetargowej
		if(empty($zlecenie->idFirmy))
		{
			$zlecenie->idFirmy=Yii::app()->user->id_firmy;
			$zlecenie->idFirmy0 = Firma::model()->findByPk($zlecenie->idFirmy);
		}

		switch (Yii::app()->user->role)
		{
			case 'admin': //zawsze dostęp
				break;
			case 'student': //czy uczeń jest właścicelem firmy
				$idfirmye = Yii::app()->user->id_firmy;
				if (empty($idfirmye) || !(($zlecenie->idFirmy == Yii::app()->user->id_firmy) || (PrzetargFirma::model()->findByAttributes(array('idFirmy'=>Yii::app()->user->id_firmy))->idGrupy == $zlecenie->idGrupyPrzetargowej))) {
					throw new CHttpException(404, 'Brak uprawnień');
				}
				break;
			case 'teacher': //czy nauczyciel uczy klasę firmy
				$rec = AdminKlasy::model()->find('"t"."idAdmina" = :teacherId AND "t"."idKlasy" = :classId', array(
					':teacherId' => Yii::app()->user->id,
					':classId' => $zlecenie->idFirmy0->idKlasy
				));
				if (empty($rec))
					throw new CHttpException(404, 'Brak uprawnień');
				break;
			default:
				throw new CHttpException(404, 'Brak uprawnień');
		}

		require_once('tcpdf/tcpdf.php');

		$pdf = new TCPDF('P', PDF_UNIT, PDF_PAGE_FORMAT, true, 'utf-8', false);

		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor('imaginalis.pl');
		$pdf->SetTitle('Nota obciążeniowa #' . $zlecenie->id . ' ' . $zlecenie->kontrahent->nazwa);
		$pdf->SetSubject('Nota obciążeniowa od ' . $zlecenie->kontrahent->nazwa);
		$pdf->SetKeywords('nota obciążeniowa, ' . $zlecenie->kontrahent->nazwa, ', ' . $zlecenie->idZlecenia0->dziedzina->nazwa);

		$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
		$pdf->SetFont('helvetica', 'BI', 14, '', 'false');

		$pdf->SetMargins(25, 20, 25);
		$pdf->SetHeaderMargin(0);
		$pdf->SetFooterMargin(0);

		$pdf->setPrintFooter(false);
		$pdf->setPrintHeader(false);

		$pdf->SetAutoPageBreak(FALSE);

		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

		if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
				require_once(dirname(__FILE__).'/lang/eng.php');
				$pdf->setLanguageArray($l);
		}

		$pdf->AddPage();
		$pdf->SetFont('dejavusans', '', 11);

		$pdf->writeHTML($this->getController()->renderPartial(
			'application.controllers.actions.views.booknote', array('zlecenie' => $zlecenie), true),
			true, false, true, false, '');

		$pdf->Output('Nota obciążeniowa #' . $zlecenie->id . ' ' . $zlecenie->kontrahent->nazwa . '.pdf', 'I');
	}
}
